function [fitresult, gof] = createFit(c_log, I_log)
%CREATEFIT(C_LOG,I_LOG)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input : c_log
%      Y Output: I_log
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, CFIT, SFIT.

%  Auto-generated by MATLAB on 25-May-2016 15:37:02


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( c_log, I_log );

% Set up fittype and options.
ft = fittype( 'poly1' );
opts = fitoptions( ft );
opts.Lower = [-Inf -Inf];
opts.Upper = [Inf Inf];
ex = excludedata( xData, yData, 'Indices', [1 2 13 14] );
opts.Exclude = ex;

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Create a figure for the plots.
figure( 'Name', 'untitled fit 1' );

% Plot fit with data.
subplot( 2, 1, 1 );
h = plot( fitresult, xData, yData, ex );
legend( h, 'I_log vs. c_log', 'Excluded I_log vs. c_log', 'untitled fit 1', 'Location', 'NorthEast' );
% Label axes
xlabel( 'c_log' );
ylabel( 'I_log' );
grid on

% Plot residuals.
subplot( 2, 1, 2 );
h = plot( fitresult, xData, yData, ex, 'residuals' );
legend( h, 'untitled fit 1 - residuals', 'Excluded I_log vs. c_log', 'Zero Line', 'Location', 'NorthEast' );
% Label axes
xlabel( 'c_log' );
ylabel( 'I_log' );
grid on


